package gov.va.genisis2.dto;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlRootElement;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;

/**
 * Data Transfer Object (DTO) to transfer user approver related details
 * 
 * @author Prasad Thummalapalli
 *
 */
@XmlRootElement(name = "userApprover")
@JsonInclude(Include.NON_NULL)
public class UserApproverDTO implements Serializable {

	private static final long serialVersionUID = -5078652365199769382L;

	private int id;
	private int userApproverId;
	private UserDTO userApproversForUserId;
	private int userId;

	/**
	 * @return the id
	 */
	public int getId() {
		return id;
	}

	/**
	 * @param id
	 *            the id to set
	 */
	public void setId(int id) {
		this.id = id;
	}

	/**
	 * @return the userApproverId
	 */
	public int getUserApproverId() {
		return userApproverId;
	}

	/**
	 * @param userApproverId
	 *            the userApproverId to set
	 */
	public void setUserApproverId(int userApproverId) {
		this.userApproverId = userApproverId;
	}

	/**
	 * @return the userApproversForUserId
	 */
	public UserDTO getUserApproversForUserId() {
		return userApproversForUserId;
	}

	/**
	 * @param userApproversForUserId
	 *            the userApproversForUserId to set
	 */
	public void setUserApproversForUserId(UserDTO userApproversForUserId) {
		this.userApproversForUserId = userApproversForUserId;
	}

	/**
	 * @return the userId
	 */
	public int getUserId() {
		return userId;
	}

	/**
	 * @param userId
	 *            the userId to set
	 */
	public void setUserId(int userId) {
		this.userId = userId;
	}
}